<?
/*
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	Filename:         [CLASS] access@php.php
	What is it:       A class that permits an easy use of access under php.
	Author:           Valerio "Lotti" Riva
	Thanks To:        www.html.it, Fabio Sutto (the author of the article http://freephp.html.it/articoli/view_articolo.asp?id=64)
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
Aloha to all! This class was written by Valerio "Lotti" Riva and you can use it and modify it for entire.
This class is just a collection of simple instruction with COM/ADO classes. Everything that appears on this file
is taked form HTML.it (http://freephp.html.it/articoli/view_articolo.asp?id=64) and is copy, glued and rearrenged by me.
If you experience some problems or somethings that doesn't work perfectly, feel free to contact me at lotti@fastwebnet.it.
You will be welcome. If something sounds strange to you, you can also contact me. However there is an exhausting guide 
at http://freephp.html.it/articoli/view_articolo.asp?id=64 (in italian). For other instructions that are not present on
this url, there will be a comment. Good Work :)
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
*/

class dbaccess
{   
/*
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
Variables definitions.
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
*/
    var $dbdir; //the directory where the database will be (it needs to be set every time you create a new object)
	var $dbname; //the filename of the database (it needs to be set every time you create a new object)
	var $dbpass; //share-password of the database (the general password, not user password)
	var $dbnewpass; //share-password again.. if you want change it, you have to set it here before call the procedure.
	var $values; //the variable where the results of your query will be sent.
	var $nrow; //this variable contains the number of row extracted by query
	var $lastquery; //this is to keep in memory the last query sent to database (it's has no functionally, i know, but.. :P)
	var $properties; //this is the variable that will contains the requested properties of a table or database.

/*
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
Functions definitions.
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
*/
		
/*
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	Create function:
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@	
	This function create a database. The paramater that is needed (it has also a defailt value, 5)
	stands for the version of the JET-SQL Engine that will be used for the creation of database.
	The value that accept this function are: 1;2;3;4;5;6.
	E.G.: $class->create(); or $class->create(4);
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@	
	Class variables that need to be setted before call this function:	$dbdir, $dbname
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@	
	Return Value: TRUE
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@	
*/

	function create($dbtype=5)
	{ 
	//controllo variabili di classe
	if ($this->dbdir=="" || $this->dbname=="")
	die("You need to set the directory or the filename of database!");
	
	if ($dbtype<1 && $dbtype>5)
	die("This version of JET-SQL isn't contemplated.");
	
	//definizione delle varie versioni del motore JETSQL con cui si pu creare un database.
		define("JET10", 1);
		define("JET11", 2);
		define("JET20", 3);
		define("JET3x", 4);
		define("JET4x", 5); //MS Access 2000
		define("JET5x", 6);	//MS Access 2002-2003
	
		
	//array che contiene tutti i valori delle versioni del JETSQL comprensibili dalla classe ADO	
        $jet=array (1 => $JET10, 2 => $JET11, 3 => $JET20, 4 => $JET3x, 5 => $JET4x, 6 => $JET5x);

		$dbsource=$this->dbdir.$this->dbname;
		
		/****
		La stringa di inizializzazione/connessione
		****/		
		$cn_string="Provider=Microsoft.Jet.OLEDB.4.0;" ;
		$cn_string.="Jet OLEDB:Engine Type=".$jet[$dbtype].";" ;
		$cn_string.="Data Source=".$dbsource.";" ;

		//verifico che il file non esista.
		if ( file_exists($dbsource) )
	        die("This file already exist!");

		/****
		Creo un'istanza dell'oggetto predefinito ADOX.Catalog attraverso COM (ADOX  un'estensione di ADO)
		****/
		
		$db= new COM("ADOX.catalog") or die("Error: ADOX doesn't work!") ;

		/****
		Creo il database tramite il metodo Create dell'oggetto ADOX.Catalog
		****/
		
		$db->Create($cn_string) or die("It's impossible to create a database.") ;
	
		$db->Release() ;
		$db= null ;

		return TRUE;
	}
	

/*
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@	
	Query function:
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@	
	This function query the database. If you have command query (like INSERT, UPDATE, 
	DROP, DELETE, ALTER and go on..) you have to pass only the variable that contains the SQL query.
	E.G.: $class->query($query);
	If you have a query that returns some values (e.g. SELECT, JOIN..), you need to pass also an array
	that contains the fields that will be shown. E.g. If i got a table that is composed of 3 fields 
	that are: ID, NAME, SURNAME; i will pass to the function this array: $fields=array("ID","NAME","SURNAME");
	E.G: $class->query($query,$fields);
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	Class variables that need to be setted before call this function:	$dbdir, $dbname	
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	Return Value: TRUE
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@	
    Class variables that are modified by this function:
	
	$values[(int)][(string)]		(2 dimension array)			Here you can find your query result organised in a 2 dimension array
																1st dimension: is the rows of result
																2nd dimension: the fields of the rows
												
	$nrow							(int)						Number of the rows that the query return
	
	$lastquery						(string)					It contains the last query sent to database.
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
*/

	function query($query,$fields=0)
	{

	//controllo variabili di classe
	if ($this->dbdir=="" || $this->dbname=="")
	die("You need to set the directory or the filename of database!");
	
		/* I parametri di connessione */
		$dbsource=$this->dbdir.$this->dbname;
		
		$cn_string="Provider=Microsoft.Jet.OLEDB.4.0;" ;
		$cn_string.="Data Source=".$dbsource.";" ;
		$cn_string.="Jet OLEDB:Database Password=".$this->dbpass.";" ;		
				
		/* La connessione */
		if (!file_exists($dbsource)) die("This database doesn't exist!");	
		
		$cn= new COM("ADODB.Connection");
		$cn->open($cn_string) ;
		
		/* Istanziamo un oggetto Recordset
		e inviamo la query attraverso
		il metodo Open() */
		$rs= new COM("ADODB.Recordset") ;
                $rs->Open($query,$cn);
       	
		/* Ciclo per recuperare i valori dal recordset
		EOF= tutto il set di dati  stato esaminato 
		e il cursore  giunto in fondo */
			if ($fields!=0)
			{
			 $chiudiconn="ok";
			 $row=0; $j=0;
			 $n=count($fields);
				  while(!$rs->EOF)
		  		  {
		   		  for ($j=0;$j<$n;$j++)
				  { 
				    $campo=$fields[$j];
	   			    $values[$row][$campo]=$rs->Fields[$campo]->value;
				  }
			   	  $rs->MoveNext(); $row++;
				  }
			}
			
	    /* Chiusura Recordset (da non farsi nelle query di comando) */
    	if ($chiudiconn=="ok")
		$rs->Close() ;

		/* Pulizia dell'oggetto Recordset */
		$rs->Release() ;
		$rs= null ;

		/* Chiudo la connessione e libero la memoria */
		$cn->Close() ;
		$cn->Release() ;
		$cn= null ;
		
		/*Questo serve per tener conto del numero delle righe trovato*/
		$this->nrow=count($values);
		/*e questo per salvare i dati delle righe*/
		$this->values=$values;		
		/*questo per tener conto dell'ultima query usata..  inutile.. per boh quando volevo metterlo, avevo un mio motivo..*/
		$this->lastquery=$query;
		
     	return TRUE;
	}

/*
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	Optimize function:
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	This function compact the database.
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	Class variables that need to be setted before call this function:	$dbdir, $dbname	
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	Return Value: TRUE			
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
*/	
	function optimize()
	{
	//controllo variabili di classe
	if ($this->dbdir=="" || $this->dbname=="")
	die("You need to set the directory or the filename of database!");
	
		$path=$this->dbdir;
		/* Nome e password del database da compattare */
		$olddb=$this->dbname;
		$oldpass=$this->dbpass;

		/* Nome provvisorio database compattato */
		$newdb="new_".$this->dbname;
		$newpass=$this->dbpass;


		/* ConnString verso il database da compattare */
		$oldConn="Provider=Microsoft.Jet.OLEDB.4.0;" ;
		$oldConn.="Data Source=".$path.$olddb.";" ;
		$oldConn.="Jet OLEDB:Database Password=$oldpass;" ;

		/* ConnString verso il nuovo database (compattato) */
		$newConn="Provider=Microsoft.Jet.OLEDB.4.0;";
		$newConn.="Data Source=".$path.$newdb.";" ;
		$newConn.="Jet OLEDB:Database Password=$newpass;" ;

		if (!file_exists($path.$olddb)) die("This database doesn't exist!");	
		/* Controllo che non esista gi un file con il nome provvisorio scelto */
		if(file_exists($path.$newdb)) die("Error: New Database already exists!");
	
		/* Istanzio l'oggetto che fornisce il metodo Compact() */
		$je=new COM("JRO.JetEngine") or die("Optimization Failed");
		/* Compatta il database e setta una nuova password */
		$je->CompactDatabase($oldConn,$newConn) ;
		$je->Release() ;
		$je= null ;

		/* Elimina il vecchio database */
		unlink($olddb);

		/* Rinomina il db compattato con il vecchio nome */		
		rename($newdb,$olddb);
		
		return TRUE;
	}
	
/*
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	Changepass function:
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	This function permits to change the share level password of the database. The function
	need a parameter to work. The default value is 2.
	E.G.:
	To remove database's password:
	$class->changepass(0);								Class variables needed to work: $dbpass.
	To apply database's password:
	$class->changepass(1);								Class variables needed to work: $dbnewpass.
	To update database's password:
	$class->changepass(2); or $class->changepass();		Class variables needed to work: $dbpass, $dbnewpass.
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	Class variables that need to be setted before call this function:	$dbdir, $dbname.
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	Return Value: TRUE			
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    Class variables that are modified by this function:
	
	$dbpass								(string)						It will contain the actual database's password 
																
	$dbnewpass							(string)						It will be reset
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
*/	
	
	function changepass($action="2")
	{
		//controllo variabili di classe
		if ($this->dbdir=="" || $this->dbname=="")
		die("You need to set the directory or the filename of database!");
		
        if ($action==0 && $this->dbpass=="")
		die("Are you sure to have setted the database password?");
		elseif ($action==1 && $this->dbnewpass=="")
		die("Are you sure to have setted the new password?");
		elseif ($action==2 && $this->dbnewpass=="" && $this->dbpass=="")
		die("Are you sure to have setted the new and old passwords?");

		$dbsource=$this->dbdir.$this->dbname;

		/* La query */
		switch ($action)
		{
		 case 0:
 		  $query="ALTER DATABASE PASSWORD NULL ".$this->dbpass;
		 break;
		 case 1:
		  $query="ALTER DATABASE PASSWORD ".$this->dbnewpass." NULL";		 
		 break;
 		 case 2:
		  $query="ALTER DATABASE PASSWORD ".$this->dbnewpass." ".$this->dbpass;
		 break;
		}

		/* La stringa di connessione, notare MODE */
		$cn_string="Provider=Microsoft.Jet.OLEDB.4.0;" ;
		$cn_string.="Mode= 12 ;" ;
		$cn_string.="Jet OLEDB:Database Password=".$this->dbpass.";";
		$cn_string.="Data Source=$dbsource;" ;

		if (!file_exists($dbsource)) die("This database doesn't exist!");	
		
		$cn= new COM("ADODB.Connection");

		$cn->Open($cn_string) ;

		$rs=new COM("ADODB.Recordset") ;

		$rs->Open($query,$cn) ;

		/* Pulizia del recordset */
		$rs->Release() ;
		$rs= null ;

		/* Chiudiamo la connessione e liberiamo la memoria */
		$cn->Close() ;
		$cn->Release() ;
		$cn= null ;
	   

		switch ($action)
		{
		 case 0:
		  $this->dbpass="";		
		  $this->dbnewpass="";				  
		 break;
		 case 1:
		  $this->dbnewpass="";						 
		 break;
		 case 2:
	      /*aggiorna la variabile dbpass con il nuovo valore impostato sul database*/		
          $this->dbpass=$this->dbnewpass;
		  /*poi azzera la variabile contenente la nuova password*/
		  $this->dbnewpass="";
		 break;
		}
 
		return TRUE;
	}
	
/*
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@	
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
*/
	
}

/*
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
																EOF
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
*/
?>
